/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class SortedCopyOnWriteSet<E, C extends Comparable<C>>
implements Iterable<E> {
    private volatile Entry<E, C>[] array = new Entry[0];

    public boolean add(E element, C comparable) {
        Objects.requireNonNull(element, "element cannot be null");
        Entry<E, C> entry = new Entry<E, C>(element, comparable);
        int insertIndex = -1;
        for (int index = 0; index < this.array.length; ++index) {
            if (insertIndex == -1 && entry.compareTo(this.array[index]) < 0) {
                insertIndex = index;
            }
            if (!this.array[index].is(element)) continue;
            return false;
        }
        if (insertIndex == -1) {
            insertIndex = this.array.length;
        }
        Entry[] newArray = new Entry[this.array.length + 1];
        System.arraycopy(this.array, 0, newArray, 0, insertIndex);
        newArray[insertIndex] = entry;
        System.arraycopy(this.array, insertIndex, newArray, insertIndex + 1, this.array.length - insertIndex);
        this.array = newArray;
        return true;
    }

    public boolean remove(E element) {
        Objects.requireNonNull(element, "element cannot be null");
        int removeIndex = -1;
        for (int index = 0; index < this.array.length; ++index) {
            if (!this.array[index].is(element)) continue;
            removeIndex = index;
            break;
        }
        if (removeIndex < 0) {
            return false;
        }
        Entry[] newArray = new Entry[this.array.length - 1];
        System.arraycopy(this.array, 0, newArray, 0, removeIndex);
        System.arraycopy(this.array, removeIndex + 1, newArray, removeIndex, this.array.length - removeIndex - 1);
        this.array = newArray;
        return true;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this.array);
    }

    private static class Entry<E, C extends Comparable<C>>
    implements Comparable<Entry<E, C>> {
        private E element;
        private C comperable;

        public Entry(E element, C comperable) {
            this.element = element;
            this.comperable = comperable;
        }

        public E getElement() {
            return this.element;
        }

        @Override
        public int compareTo(Entry<E, C> other) {
            return this.comperable.compareTo(other.comperable);
        }

        public boolean is(E element) {
            return this.element.equals(element);
        }
    }

    private class ElementIterator
    implements Iterator<E> {
        private final Entry<E, C>[] array;
        private int cursor = 0;

        public ElementIterator(Entry<E, C>[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            int index = this.cursor++;
            return this.array[index].getElement();
        }
    }
}

